	% Example 8.9
	clear all
	clc 
	%  Synthesis of lowpass Lattice filters
	Wc = 1;	Ws = 1.42;	r = 0.15; Amax =-10*log10(1-r^2); Amin = 40;
	N = CA_ORDER_S(Wc, Ws, Amax, Amin)
	N = 5;		
	[G, Z, R_ZEROS, P, Wsnew] = CA_POLES_S(Wc, Ws, Amax, Amin, N)	
	xmax = 1;	xmin = -2;	ymax = 2;
	
	figure(1)
	PLOT_PZ_S(Z, P, Wc, Ws, xmin, xmax, ymax*1.2)
	zoom on
	[Zodd, Podd, Zeven, Peven] = SORT_LATTICE_POLES_LP_S(P);
	
	figure(2)
	PLOT_PZ_S(Zeven, Peven, Wc, Ws, xmin, xmax, ymax);
	zoom on	
	
	figure(3)
	PLOT_PZ_S(Zodd, Podd, Wc, Ws, xmin, xmax, ymax);
	zoom on
	omega = linspace(0, 10, 1000); 
	Hodd = PZ_2_FREQ_S(0.5, Zodd, Podd, omega);	
	Heven = PZ_2_FREQ_S(0.5, Zeven, Peven, omega);
	Att = MAG_2_ATT(Hodd-Heven);	
	
	figure(4)
	subplot('position', [0.08 0.4 0.90 0.5]); 
	PLOT_ATT_S(omega, Att)
	axis([0, 10, 0, 60]);
	Zodd
	Podd
	G = 1;
	[Xnum, Xden] = S_2_Z(G, Zodd, Podd)		
	[R, K, RL] = RICHARDS_REACTANCE_S(Xnum, Xden)
	Zeven
	Peven
	[Xnum, Xden] = S_2_Z(G, Zeven, Peven)		
	[R, K, RL] = RICHARDS_REACTANCE_S(Xnum, Xden)
	
	
